<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg=".">
  <xsl:output method="xml" indent="yes"/>
  <!--##############  PARAMETER  ####################-->
  <xsl:param name="id">1</xsl:param>
  <xsl:param name="cmNetworkId">text</xsl:param>
  <xsl:param name="ipAddress">192.168.1.1</xsl:param>
  <xsl:param name="portNumber">0</xsl:param>
  <xsl:param name="netGroup">1</xsl:param>
  <xsl:param name="netNode">1</xsl:param>
  <!--##############  VARIABLES  ####################-->
  <!--##############  BEGIN Namspace cfg   ####################-->
  <cfg:Stylesheet mode="TRANSFORM" version="1.0.1" versionscope="ALL_FILES" backup="true" backupdir="junk"/>
  <cfg:Description lang="DE"/>
  <cfg:Description lang="EN">Insert Condition Monitoring Parameters</cfg:Description>
  <cfg:CfgExplorerParam name="StartupMode">SINGLE_FILE</cfg:CfgExplorerParam>
  <cfg:Texts>
  </cfg:Texts>
  <!--##############  END Namspace cfg   ####################-->
  <!--##############  MAIN Template for any ROOT ####################-->
  <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
  <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
  <!-- we do not copy attributes anymore (exception panelEncoding). Thus we force the creation of new rpsDisplayNames, which have been wrong in some RPS-versions  -->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()">
    </xsl:apply-templates>
    </xsl:element>
  </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
    <xsl:copy/>
  </xsl:template>
  <xsl:template match="CONFIG_NETWORK">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'SUPPORT_INFO' and ../CM_SERVER = false()">
            <xsl:apply-templates select="."/>
            <xsl:call-template name="InsertCMServer"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template name="InsertCMServer">
    <xsl:element name="CM_SERVER">
      <xsl:element name="id">
        <xsl:value-of select="$id"/>
      </xsl:element>
      <xsl:element name="cmNetworkId">
        <xsl:value-of select="$cmNetworkId"/>
      </xsl:element>
      <xsl:element name="ipAddress">
        <xsl:value-of select="$ipAddress"/>
      </xsl:element>
      <xsl:element name="portNumber">
        <xsl:value-of select="$portNumber"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="NODE">
    <xsl:element name="{name()}">
      <xsl:choose>
        <xsl:when test="netGroup = $netGroup and netNode = $netNode">
          <xsl:for-each select="*">
            <xsl:choose>
              <xsl:when test="name() = 'syncRequired'">
                <xsl:apply-templates select="."/>
                <xsl:if test="../assignedCMServer = false()">
                  <xsl:element name="assignedCMServer">
                    <xsl:value-of select="$id"/>
                  </xsl:element>
                </xsl:if>
              </xsl:when>
              <xsl:when test="name() = 'assignedCMServer'">
                <xsl:element name="assignedCMServer">
                  <xsl:value-of select="$id"/>
                </xsl:element>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="."/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="*"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <xsl:template match="CM_SERVER">
    <xsl:element name="CM_SERVER">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'id'">
            <xsl:element name="id">
              <xsl:value-of select="$id"/>
            </xsl:element>
          </xsl:when>
          <xsl:when test="name() = 'cmNetworkId'">
            <xsl:element name="cmNetworkId">
              <xsl:value-of select="$cmNetworkId"/>
            </xsl:element>
          </xsl:when>
          <xsl:when test="name() = 'ipAddress'">
            <xsl:element name="ipAddress">
              <xsl:value-of select="$ipAddress"/>
            </xsl:element>
          </xsl:when>
          <xsl:when test="name() = 'portNumber'">
            <xsl:element name="portNumber">
              <xsl:value-of select="$portNumber"/>
            </xsl:element>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>
